// click.js
document.addEventListener('DOMContentLoaded', function() {
    
    // MES drones avec leurs IDs
    const myPierre = document.getElementById('my-pierre');
    const myFeuille = document.getElementById('my-feuille');
    const myCiseau = document.getElementById('my-ciseau');
    
    // DRONES ENNEMIS avec leurs IDs
    const enemyPierre = document.getElementById('enemy-pierre');
    const enemyFeuille = document.getElementById('enemy-feuille');
    const enemyCiseau = document.getElementById('enemy-ciseau');
    
    // VAISSEAU ENNEMI
    const enemyShip = document.querySelector('.ship-right');
    
    // JOKERS
    const myJoker = document.getElementById('my-joker');
    const enemyJoker = document.getElementById('enemy-joker');
    
    // OVERLAY et INTERFACE JOKER
    const jokerOverlay = document.getElementById('joker-overlay');
    const jokerInterface = document.getElementById('joker-interface');
    const reparerBtn = document.getElementById('reparer-btn');
    const blufferBtn = document.getElementById('bluffer-btn');
    
    // BARRES DE VIE
    const barreVieEnemyPierre = document.querySelector('#enemy-pierre').closest('.droneWrap').querySelector('.barreVie');
    const barreVieEnemyFeuille = document.querySelector('#enemy-feuille').closest('.droneWrap').querySelector('.barreVie');
    const barreVieEnemyCiseau = document.querySelector('#enemy-ciseau').closest('.droneWrap').querySelector('.barreVie');
    const barreVieEnemyShip = document.querySelector('.column:last-child .topInfo .pvBar'); 
    
    // Barres de vie alliées
    const barreVieMyPierre = document.querySelector('#my-pierre').closest('.droneWrap').querySelector('.barreVie');
    const barreVieMyFeuille = document.querySelector('#my-feuille').closest('.droneWrap').querySelector('.barreVie');
    const barreVieMyCiseau = document.querySelector('#my-ciseau').closest('.droneWrap').querySelector('.barreVie');
    
    let droneSelectionne = null;
    let typeDroneSelectionne = null;
    let estEnModeSelection = false;
    let estEnModeJoker = false;
    let ciblesPossibles = [];
    
    // Initialiser les barres de vie
    function initialiserBarresVie() {
        [barreVieEnemyPierre, barreVieEnemyFeuille, barreVieEnemyCiseau].forEach(barre => {
            barre.dataset.pv = 100;
            updateBar(barre);
        });

        [barreVieMyPierre, barreVieMyFeuille, barreVieMyCiseau].forEach(barre => {
            barre.dataset.pv = 100;
            updateBar(barre);
        });

        barreVieEnemyShip.dataset.pv = 100;
        updateBar(barreVieEnemyShip);
    }

    // Diminuer une barre de vie ennemie
    function diminuerBarreVieEnnemie(cible, degats = 25) {
        if (cible === enemyShip) {
            let pvActuel = parseInt(barreVieEnemyShip.dataset.pv);
            pvActuel = Math.max(0, pvActuel - degats);
            barreVieEnemyShip.dataset.pv = pvActuel;
            updateBar(barreVieEnemyShip);
        } else {
            let barre = null;
            if (cible === enemyPierre) barre = barreVieEnemyPierre;
            else if (cible === enemyFeuille) barre = barreVieEnemyFeuille;
            else if (cible === enemyCiseau) barre = barreVieEnemyCiseau;

            if (barre) {
                let pvActuel = parseInt(barre.dataset.pv);
                pvActuel = Math.max(0, pvActuel - degats);
                barre.dataset.pv = pvActuel;
                updateBar(barre);
            }
        }
    }
    
    // Réparer un drone allié
    function reparerDrone(drone, type) {
        let barre = null;
        if (drone === myPierre) barre = barreVieMyPierre;
        else if (drone === myFeuille) barre = barreVieMyFeuille;
        else if (drone === myCiseau) barre = barreVieMyCiseau;

        if (barre) {
            let pvActuel = parseInt(barre.dataset.pv);
            pvActuel = Math.min(100, pvActuel + 25);
            barre.dataset.pv = pvActuel;
            updateBar(barre);
            
            // Animation de réparation
            drone.style.transform = 'scale(1.1)';
            setTimeout(() => {
                drone.style.transform = 'scale(1)';
            }, 300);
        }
    }
    
    function resetStyles() {
        [myPierre, myFeuille, myCiseau].forEach(drone => {
            drone.style.transform = 'scale(1)';
            drone.style.boxShadow = 'none';
        });

        [enemyPierre, enemyFeuille, enemyCiseau].forEach(drone => {
            drone.style.transform = 'scale(1)';
            drone.style.boxShadow = 'none';
            drone.style.cursor = 'default';
        });

        enemyShip.style.boxShadow = 'none';
        enemyShip.style.border = '2px solid #666';
        enemyShip.style.filter = 'none';
        enemyShip.style.cursor = 'default';
        
        droneSelectionne = null;
        typeDroneSelectionne = null;
        estEnModeSelection = false;
        ciblesPossibles = [];
    }
    
    function fermerJoker() {
        jokerOverlay.style.display = 'none';
        jokerInterface.style.display = 'none';
        myJoker.classList.remove('active');
        estEnModeJoker = false;
    }
    
    function getCiblesPossibles(typeAttaquant) {
        const cibles = [enemyShip];

        switch(typeAttaquant) {
            case 'pierre':
                cibles.push(enemyCiseau);
                break;
            case 'feuille':
                cibles.push(enemyPierre);
                break;
            case 'ciseau':
                cibles.push(enemyFeuille);
                break;
        }
        
        return cibles;
    }
    
    function handleMonDroneClick(drone, type) {
        if (estEnModeJoker) return;
        
        resetStyles();
        droneSelectionne = drone;
        typeDroneSelectionne = type;
        estEnModeSelection = true;
        
        drone.style.transform = 'scale(1.2)';
        drone.style.boxShadow = '0 0 15px rgba(255,255,255,0.8)';
        
        ciblesPossibles = getCiblesPossibles(type);
        
        ciblesPossibles.forEach(cible => {
            if (cible === enemyShip) {
                cible.style.boxShadow = '0 0 20px rgba(255, 100, 100, 0.8)';
                cible.style.border = '2px solid #ff6b6b';
                cible.style.filter = 'brightness(1.3)';
                cible.style.cursor = 'pointer';
            } else {
                cible.style.transform = 'scale(1.15)';
                cible.style.boxShadow = '0 0 10px rgba(255,215,0,0.6)';
                cible.style.cursor = 'pointer';
            }
        });
    }
    
    // Gestion du clic sur le joker
    function handleJokerClick() {
        if (estEnModeSelection) {
            resetStyles();
        }
        
        estEnModeJoker = true;
        myJoker.classList.add('active');
        jokerOverlay.style.display = 'flex';
        jokerInterface.style.display = 'flex';
    }
    
    // CONFIRMATION D'ATTAQUE
    function handleCibleEnnemieClick(cible, typeCible, event) {
        if (!estEnModeSelection) return;
        if (!ciblesPossibles.includes(cible)) return;

        event.stopPropagation();

        diminuerBarreVieEnnemie(cible, 25);

        // Animation uniquement pour les drones
        if (cible !== enemyShip) {
            cible.style.transform = 'scale(1.1)';
            setTimeout(() => {
                cible.style.transform = 'scale(1)';
            }, 200);
        }

        resetStyles();
        console.log(`Attaque ${typeDroneSelectionne} → ${typeCible}`);
    }
    
    // CLICS joueurs
    myPierre.addEventListener('click', () => handleMonDroneClick(myPierre, 'pierre'));
    myFeuille.addEventListener('click', () => handleMonDroneClick(myFeuille, 'feuille'));
    myCiseau.addEventListener('click', () => handleMonDroneClick(myCiseau, 'ciseau'));
    
    // Joker
    myJoker.addEventListener('click', handleJokerClick);
    
    // Boutons joker
    reparerBtn.addEventListener('click', () => {
        if (droneSelectionne) {
            reparerDrone(droneSelectionne, typeDroneSelectionne);
        }
        fermerJoker();
    });
    
    blufferBtn.addEventListener('click', () => {
        // Logique de bluff à implémenter
        console.log("Bluff activé !");
        fermerJoker();
    });
    
    enemyPierre.addEventListener('click', (e) => handleCibleEnnemieClick(enemyPierre, 'pierre', e));
    enemyFeuille.addEventListener('click', (e) => handleCibleEnnemieClick(enemyFeuille, 'feuille', e));
    enemyCiseau.addEventListener('click', (e) => handleCibleEnnemieClick(enemyCiseau, 'ciseau', e));
    enemyShip.addEventListener('click', (e) => handleCibleEnnemieClick(enemyShip, 'vaisseau', e));
    
    // Clic en dehors pour annuler
    document.addEventListener('click', function(e) {
        if (estEnModeSelection && !e.target.classList.contains('drone') && e.target !== enemyShip) {
            resetStyles();
        }
        
        if (estEnModeJoker && e.target === jokerOverlay) {
            fermerJoker();
        }
    });
    
    // BARRES DE VIE
    const allBars = document.querySelectorAll(".barreVie, .pvBar");

    allBars.forEach(bar => {
        bar.dataset.pv = 100;
        updateBar(bar);
    });

    function updateBar(bar) {
        const pv = bar.dataset.pv;
        bar.style.background = `
            linear-gradient(to right, #4CAF50 ${pv}%, #555 ${pv}%)
        `;
    }

    initialiserBarresVie();
});