<?php
require "config.php";

if (!isset($_POST['username'], $_POST['password'])) {
    echo json_encode(["success" => false, "message" => "missing"]);
    exit;
}

$username = trim($_POST['username']);
$password = $_POST['password'];

$req = $pdo->prepare("SELECT * FROM users WHERE username = ?");
$req->execute([$username]);
$user = $req->fetch(PDO::FETCH_ASSOC);

if (!$user || !password_verify($password, $user['password'])) {
    echo json_encode(["success" => false, "message" => "invalid"]);
    exit;
}

$_SESSION['user'] = $user['username'];
$_SESSION['user_id'] = $user['id'];  // <<<<<< LA LIGNE QUI MANQUAIT

echo json_encode([
    "success" => true,
    "username" => $user['username']
]);
?>
