document.addEventListener("DOMContentLoaded", () => {

    /* RESET */
    document.getElementById("reset_game").addEventListener("click", () => {
        $.post("game.php", { base: "reset" }, () => location.reload());
    });

    const idJoueur = parseInt(document.getElementById("id_joueur").textContent);

    const myPierre = document.getElementById("my-pierre");
    const myFeuille = document.getElementById("my-feuille");
    const myCiseau = document.getElementById("my-ciseau");

    const enemyPierre = document.getElementById("enemy-pierre");
    const enemyFeuille = document.getElementById("enemy-feuille");
    const enemyCiseau = document.getElementById("enemy-ciseau");
    const enemyShip = document.querySelector(".ship-right");

    const myJoker = document.getElementById("my-joker");
    const enemyJoker = document.getElementById("enemy-joker");

    const pvBars = document.querySelectorAll(".pvBar");
    const droneBars = document.querySelectorAll(".barreVie");
    const canvasZone = document.getElementById("canvasZone");

    let isMyTurn = false;
    let inputLocked = false;

    let selectedDrone = null;
    let selectedType = null;
    let possibleTargets = [];

    let defenseMode = false;
    let defenseSelected = null;

    let jokerMode = false;
    let repairMode = false;
    let bluffMode = false;
    let repairSelected = null;

    let myPierreHP = 3;
    let myFeuilleHP = 3;
    let myCiseauHP = 3;

    /* =============== SYSTÈME ANIMATION DEGÂTS =============== */
    let previousHP = {
        myPierre: 3,
        myFeuille: 3,
        myCiseau: 3,
        enemyPierre: 3,
        enemyFeuille: 3,
        enemyCiseau: 3,
        myShip: 5,
        enemyShip: 5
    };

    function fillBar(el, cur, max) {
        const percent = (cur / max) * 100;
        el.style.setProperty('--current-percent', percent + '%');
        el.style.background = `linear-gradient(to right, #4CAF50 ${percent}%, #444 ${percent}%)`;
    }

    function flashHPBar(bar) {
        bar.classList.remove("hpDamageFlash");
        void bar.offsetWidth; // Force reflow pour relancer l'animation
        bar.classList.add("hpDamageFlash");

        setTimeout(() => {
            bar.classList.remove("hpDamageFlash");
        }, 600);
    }

    function checkDamageAndAnimate(currentHP, previousHP, barElement) {
        if (currentHP < previousHP) {
            flashHPBar(barElement);
            return true;
        }
        return false;
    }

    /* =============== DRONE VISUAL STATE =============== */
    function updateDroneState(drone, hp) {
        // NE PAS modifier l'apparence si le drone fait partie de la sélection en cours
        if (selectedDrone && possibleTargets.includes(drone)) {
            return; // Laisser l'apparence gérée par selectAttackDrone
        }
        
        if (hp < 1) {
            drone.classList.add("drone-damaged");
            drone.classList.remove("drone-alive");
            drone.style.opacity = "0.5";
            drone.style.filter = "grayscale(1)";
            drone.style.transform = "scale(1)";
            drone.style.boxShadow = "none";
        } else {
    drone.classList.remove("drone-damaged");
    drone.classList.add("drone-alive");
    drone.style.opacity = "1";
    drone.style.filter = "grayscale(0)"; // ← Ça pourrait enlever le gris
    // Remettre l'échelle à 1 seulement si pas sélectionné
    if (drone !== selectedDrone && !possibleTargets.includes(drone)) {
        drone.style.transform = "scale(1)";
    }
}
    }

    /* =============== RESET SELECTION =============== */
    function resetSelection() {
        selectedDrone = null;
        selectedType = null;
        possibleTargets = [];
        defenseSelected = null;

        const allDrones = [myPierre, myFeuille, myCiseau, enemyPierre, enemyFeuille, enemyCiseau];

        allDrones.forEach(d => {
            d.style.transform = "scale(1)";
            d.style.boxShadow = "none";

            if (d.classList.contains("drone-damaged")) {
                d.style.opacity = "0.5";
                d.style.filter = "grayscale(1)";
            } else {
                d.style.opacity = "1";
                d.style.filter = "grayscale(0)";
            }
        });

        enemyShip.style.boxShadow = "none";
        enemyShip.classList.remove("clicable");

        repairMode = false;
        jokerMode = false;
        bluffMode = false;
        repairSelected = null;
    }

    /* =============== CIBLES ATTAQUE =============== */
    function getTargets(type) {
        if (type === "pierre") return [enemyCiseau, enemyShip];
        if (type === "feuille") return [enemyPierre, enemyShip];
        if (type === "ciseau") return [enemyFeuille, enemyShip];
        return [enemyShip];
    }

    function selectAttackDrone(drone, type) {
        if (!isMyTurn || defenseMode || jokerMode || repairMode || bluffMode) return;
        if (inputLocked) return;
        if (drone.classList.contains("drone-damaged")) return;

        resetSelection();

        selectedDrone = drone;
        selectedType = type;
        possibleTargets = getTargets(type);

        /* Le drone sélectionné grossit */
        drone.style.transform = "scale(1.5)";
        drone.style.opacity = "1";
        drone.style.filter = "grayscale(0)";

        /* Tous les drones ennemis - les cibles deviennent gris, les cibles grossissent */
        [enemyPierre, enemyFeuille, enemyCiseau].forEach(e => {
            if (e.classList.contains("drone-damaged")) {
                // mort → reste gris
                e.style.opacity = "0.5";
                e.style.filter = "grayscale(1)";
                e.style.transform = "scale(1)";
                return;
            }

            if (possibleTargets.includes(e)) {
                // Cible valide → grossit et normal
                e.style.transform = "scale(1.5)";
                e.style.opacity = "1";
                e.style.filter = "grayscale(0)";
            } else {
                // NON cible → gris et taille normale
                e.style.opacity = "0.5";
                e.style.filter = "grayscale(1)";
                e.style.transform = "scale(1)";
            }
        });

        /* Ship ciblable */
        if (possibleTargets.includes(enemyShip)) {
            enemyShip.classList.add("clicable");
            enemyShip.style.boxShadow = "0 0 15px white";
        } else {
            enemyShip.style.boxShadow = "none";
            enemyShip.classList.remove("clicable");
        }
    }

    /* =============== CLICK CIBLE =============== */
    function clickTarget(target) {
        if (!isMyTurn || defenseMode || jokerMode || repairMode || bluffMode) return;
        if (!selectedDrone) return;
        if (!possibleTargets.includes(target)) return;

        const cible = target.dataset.type || "vaisseau";

        $.post("game.php", {
            base: "attack",
            joueur: idJoueur,
            drone: selectedType,
            cible: cible
        });

        inputLocked = true;
        resetSelection();
    }

    /* =============== DEFENSE =============== */
    function selectDefenseDrone(drone, type) {
        if (!defenseMode) return;
        if (drone.classList.contains("drone-damaged")) return;

        // RESET VISUEL avant de sélectionner un nouveau drone
        [myPierre, myFeuille, myCiseau].forEach(d => {
            d.style.transform = "scale(1)";
            d.style.boxShadow = "none";
        });

        // Si on reclique sur le même → validation (comme l'attaque)
        if (defenseSelected === type) {
            $.post("game.php", {
                base: "defend",
                joueur: idJoueur,
                drone: type
            });
            
            inputLocked = true;
            resetSelection();
            return;
        }

        // Sinon on sélectionne
       defenseSelected = type;
selectedDrone = drone; // empêche le tick serveur de reset l’échelle
drone.style.transform = "scale(1.5)";

    }

    /* =============== JOKER MENU =============== */
    myJoker.addEventListener("click", () => {
        if (inputLocked) return;

        if (!isMyTurn || defenseMode) return;

        // 🔥 BLOQUE LE JOKER SI AUCUN RESTANT
        if (parseInt(myJoker.textContent.replace("x","")) <= 0) return;

        resetSelection();
        jokerMode = true;

        canvasZone.innerHTML = `
            <div class="joker-left">
                <button id="jokerRepair">Réparer un drone</button>
            </div>
            <div class="joker-right">
                <button id="jokerBluff">Bluff</button>
            </div>
        `;
    });

    /* STOP PROPAGATION */
    canvasZone.addEventListener("click", e => e.stopPropagation());

    /* =============== ACTIONS JOKER =============== */
    canvasZone.addEventListener("click", e => {
        if (e.target.id === "jokerRepair") {
            repairMode = true;
            jokerMode = false;
            bluffMode = false;

            canvasZone.textContent = "Choisissez un drone à réparer";

            if (myPierreHP < 3) myPierre.style.transform = "scale(1.5)";
            if (myFeuilleHP < 3) myFeuille.style.transform = "scale(1.5)";
            if (myCiseauHP < 3) myCiseau.style.transform = "scale(1.5)";
        }

        if (e.target.id === "jokerBluff") {
            bluffMode = true;
            jokerMode = false;
            repairMode = false;

            canvasZone.dataset.leftChoice = "";

            canvasZone.innerHTML = `
                <div class="bluff-title">Annonce</div>
                <div class="bluff-left" id="bluffLeft">
                    <button class="bluffChoiceLeft" data-left="pierre">Pierre</button>
                    <button class="bluffChoiceLeft" data-left="feuille">Feuille</button>
                    <button class="bluffChoiceLeft" data-left="ciseau">Ciseau</button>
                </div>
                <div class="bluff-right" id="bluffRight">
                    <button class="bluffChoiceRight" data-right="pierre" disabled>Pierre</button>
                    <button class="bluffChoiceRight" data-right="feuille" disabled>Feuille</button>
                    <button class="bluffChoiceRight" data-right="ciseau" disabled>Ciseau</button>
                </div>
            `;
        }

        if (e.target.classList.contains("bluffChoiceLeft")) {
            const choix = e.target.dataset.left;
            canvasZone.dataset.leftChoice = choix;

            document.querySelector(".bluff-title").textContent = "Réalité";

            document.querySelectorAll(".bluffChoiceLeft").forEach(btn => {
                btn.disabled = true;
                btn.classList.add("disabledBtn");
            });

            document.querySelectorAll(".bluffChoiceRight").forEach(btn => {
                btn.disabled = false;
                btn.classList.add("activeBtn");
            });
        }

        if (e.target.classList.contains("bluffChoiceRight") && !e.target.disabled) {
            const droite = e.target.dataset.right;
            const gauche = canvasZone.dataset.leftChoice;

            $.post("game.php", {
                base: "bluff",
                joueur: idJoueur,
                left: gauche,
                right: droite
            });

            inputLocked = true;
            resetSelection();
            canvasZone.textContent = "En attente de l'adversaire…";
        }
    });

    /* =============== RÉPARATION =============== */
   function handleRepairClick(drone, type, hp) {
    if (!repairMode) return;

    // 2e clic sur le même drone → on confirme la réparation
    if (repairSelected === type) {
        $.post("game.php", {
            base: "repair",
            joueur: idJoueur,
            drone: type
        });
        
        inputLocked = true;
        resetSelection();
        return;
    }

    // 1er clic → on sélectionne le drone à réparer
    repairSelected = type;
    selectedDrone = drone;            // 🔥 IMPORTANT : on bloque le reset auto

    [myPierre, myFeuille, myCiseau].forEach(d => {
        if (d !== drone) {
            d.style.boxShadow = "none";
            d.style.transform = "scale(1)";
        }
    });

    // On le laisse BIEN GROS jusqu'à la confirmation
    drone.style.transform = "scale(1.5)";
    drone.style.boxShadow = "0 0 50px green";
}


    /* =============== BLUFF VERIF =============== */
    canvasZone.addEventListener("click", e => {
        if (e.target.id === "bluffTrue") {
            $.post("game.php", {
                base: "verif_bluff",
                joueur: idJoueur,
                verif: "true"
            });

            canvasZone.textContent = "En attente...";
        }

        if (e.target.id === "bluffFalse") {
            $.post("game.php", {
                base: "verif_bluff",
                joueur: idJoueur,
                verif: "false"
            });

            canvasZone.textContent = "En attente...";
        }
    });

    /* =============== UPDATE ÉTAT SERVEUR =============== */
    function actualiserEtat() {
        $.post("game.php", { base: "get" }, g => {
            if (!g) return;
            
            // === FIN DE PARTIE ===
            if (g.winner && g.winner != 0) {
                afficherEcranFin(g.winner);
                return; // stop tout le reste du jeu
            }

            /* Jokers */
            myJoker.innerHTML = "x" + g["joker" + idJoueur];
            enemyJoker.innerHTML = "x" + g["joker" + (idJoueur === 1 ? 2 : 1)];

            /* Vaisseau HP bars */
            let myShipHP, enemyShipHP;
            if (idJoueur === 1) {
                myShipHP = g.vaisseau1;
                enemyShipHP = g.vaisseau2;
                fillBar(pvBars[0], myShipHP, 5);
                fillBar(pvBars[1], enemyShipHP, 5);
            } else {
                myShipHP = g.vaisseau2;
                enemyShipHP = g.vaisseau1;
                fillBar(pvBars[0], myShipHP, 5);
                fillBar(pvBars[1], enemyShipHP, 5);
            }

            // Vérifier dégâts vaisseaux
            checkDamageAndAnimate(myShipHP, previousHP.myShip, pvBars[0]);
            checkDamageAndAnimate(enemyShipHP, previousHP.enemyShip, pvBars[1]);
            previousHP.myShip = myShipHP;
            previousHP.enemyShip = enemyShipHP;

            let gauche = idJoueur === 1 ?
                [g.pierre1, g.feuille1, g.ciseau1] :
                [g.pierre2, g.feuille2, g.ciseau2];

            let droite = idJoueur === 1 ?
                [g.pierre2, g.feuille2, g.ciseau2] :
                [g.pierre1, g.feuille1, g.ciseau1];

            myPierreHP = gauche[0];
            myFeuilleHP = gauche[1];
            myCiseauHP = gauche[2];

            // Remplir barres drones
            fillBar(droneBars[0], gauche[0], 3);
            fillBar(droneBars[1], gauche[1], 3);
            fillBar(droneBars[2], gauche[2], 3);
            fillBar(droneBars[3], droite[0], 3);
            fillBar(droneBars[4], droite[1], 3);
            fillBar(droneBars[5], droite[2], 3);

            // Vérifier dégâts drones
            checkDamageAndAnimate(gauche[0], previousHP.myPierre, droneBars[0]);
            checkDamageAndAnimate(gauche[1], previousHP.myFeuille, droneBars[1]);
            checkDamageAndAnimate(gauche[2], previousHP.myCiseau, droneBars[2]);
            checkDamageAndAnimate(droite[0], previousHP.enemyPierre, droneBars[3]);
            checkDamageAndAnimate(droite[1], previousHP.enemyFeuille, droneBars[4]);
            checkDamageAndAnimate(droite[2], previousHP.enemyCiseau, droneBars[5]);

            // Mettre à jour les HP précédents
            previousHP.myPierre = gauche[0];
            previousHP.myFeuille = gauche[1];
            previousHP.myCiseau = gauche[2];
            previousHP.enemyPierre = droite[0];
            previousHP.enemyFeuille = droite[1];
            previousHP.enemyCiseau = droite[2];

            /* === APPLY VISUAL STATES EVERY TICK === */
// Ne pas casser le visuel si une sélection (attaque OU réparation) est en cours
if (!selectedDrone && !repairMode && !repairSelected) {
    updateDroneState(myPierre, myPierreHP);
    updateDroneState(myFeuille, myFeuilleHP);
    updateDroneState(myCiseau, myCiseauHP);
    updateDroneState(enemyPierre, droite[0]);
    updateDroneState(enemyFeuille, droite[1]);
    updateDroneState(enemyCiseau, droite[2]);
}


            /* Vaisseaux textures */
            myShipHP = Math.max(0, Math.min(5, myShipHP));
            enemyShipHP = Math.max(0, Math.min(5, enemyShipHP));

            document.querySelector(".ship-left").style.backgroundImage = `url("image/ship${myShipHP}.png")`;
            document.querySelector(".ship-right").style.backgroundImage = `url("image/shipe${enemyShipHP}.png")`;

            isMyTurn = (g.joueur == idJoueur);

            // Bloque totalement l'attaquant tant que l'adversaire n'a pas défendu
            if (g.phase === "defense" && g.attaque_joueur == idJoueur) {
                inputLocked = true;
            }

            // Débloque les clics pour la défense
            if (g.phase === "defense" && g.attaque_joueur != idJoueur) {
                inputLocked = false;
            }

            // Débloque l'attaque uniquement dans la phase attente (tour normal)
            if (g.phase === "attente" && g.joueur == idJoueur) {
                inputLocked = false;
            }

            if (jokerMode || repairMode || bluffMode) return;

            if (g.phase === "attente" && !g.phase_bluff) {
                defenseMode = false;
                canvasZone.textContent = isMyTurn ? "C'est votre tour" : "En attente de l'adversaire…";
            }

            if (g.phase === "defense") {
                if (g.attaque_joueur != idJoueur) {
                    defenseMode = true;
                    canvasZone.textContent = "Choisissez votre défense";
                } else {
                    canvasZone.textContent = "En attente de la défense adverse…";
                }
            }

            if (g.phase_bluff === "attente_verif") {
                if (g.bluff_joueur != idJoueur) {
                    canvasZone.innerHTML = `
                        <div class="verifBluffBox">
                            <div class="verifTitle">Le joueur annonce qu'il joue : ${g.bluff_annonce}</div>
                            <div class="verifButtons">
                                <button id="bluffTrue" class="verifBtn vrai"></button>
                                <button id="bluffFalse" class="verifBtn faux"></button>
                            </div>
                        </div>
                    `;
                } else {
                    canvasZone.textContent = "En attente de l'adversaire…";
                }
            }
        }, "json");
    }

    setInterval(actualiserEtat, 400);

    /* =============== CLICK VIDE ANNULER =============== */
    document.addEventListener("click", e => {
        if (!selectedDrone && !defenseMode && !repairMode && !jokerMode && !bluffMode) return;

        const interactifs = [
            myPierre, myFeuille, myCiseau,
            enemyPierre, enemyFeuille, enemyCiseau,
            enemyShip, myJoker,
            ...canvasZone.querySelectorAll("*")
        ];

        if (interactifs.includes(e.target)) return;

        resetSelection();
        canvasZone.textContent = isMyTurn ? "C'est votre tour" : "En attente de l'adversaire…";
    });

    /* =============== DRONES (FINAL INTERACTIONS) =============== */
    myPierre.addEventListener("click", () => {
        if (inputLocked) return;

        if (myPierreHP < 1 && !repairMode) return;

        selectAttackDrone(myPierre, "pierre");
        handleRepairClick(myPierre, "pierre", myPierreHP);
        selectDefenseDrone(myPierre, "pierre");
    });

    myFeuille.addEventListener("click", () => {
        if (inputLocked) return;

        if (myFeuilleHP < 1 && !repairMode) return;

        selectAttackDrone(myFeuille, "feuille");
        handleRepairClick(myFeuille, "feuille", myFeuilleHP);
        selectDefenseDrone(myFeuille, "feuille");
    });

    myCiseau.addEventListener("click", () => {
        if (inputLocked) return;

        if (myCiseauHP < 1 && !repairMode) return;

        selectAttackDrone(myCiseau, "ciseau");
        handleRepairClick(myCiseau, "ciseau", myCiseauHP);
        selectDefenseDrone(myCiseau, "ciseau");
    });

    enemyPierre.addEventListener("click", () => clickTarget(enemyPierre));
    enemyFeuille.addEventListener("click", () => clickTarget(enemyFeuille));
    enemyCiseau.addEventListener("click", () => clickTarget(enemyCiseau));
    enemyShip.addEventListener("click", () => clickTarget(enemyShip));
    
    function afficherEcranFin(gagnant) {
        // Empêche le joueur d'interagir
        isMyTurn = false;
        inputLocked = true; // on bloque l'interaction pendant l'écran de fin

        // Ajout de l'écran de fin
        document.body.innerHTML += `
            <div id="endScreen">
                <img id="endImage" src="image/${gagnant == idJoueur ? "bleu.png" : "rouge.png"}">
                <button id="endBtn">Continuer</button>
            </div>
        `;

        // Style de l'écran
        const endScreen = document.getElementById("endScreen");
        endScreen.style.position = "fixed";
        endScreen.style.top = "0";
        endScreen.style.left = "0";
        endScreen.style.width = "100%";
        endScreen.style.height = "100%";
        endScreen.style.background = "rgba(0,0,0,0.85)";
        endScreen.style.display = "flex";
        endScreen.style.flexDirection = "column";
        endScreen.style.justifyContent = "center";
        endScreen.style.alignItems = "center";
        endScreen.style.zIndex = "999999";

        // Image fullscreen
        const img = document.getElementById("endImage");
        img.style.position = "absolute";
        img.style.top = "50%";
        img.style.left = "50%";
        img.style.transform = "translate(-50%, -50%)";
        img.style.width = "100vw";
        img.style.height = "100vh";
        img.style.objectFit = "cover";
        img.style.zIndex = "1";

        // Bouton au-dessus
        const btn = document.getElementById("endBtn");
        btn.style.padding = "15px 25px";
        btn.style.fontSize = "22px";
        btn.style.borderRadius = "12px";
        btn.style.background = "white";
        btn.style.color = "black";
        btn.style.cursor = "pointer";
        btn.style.border = "none";
        btn.style.position = "relative";
        btn.style.zIndex = "2";
        btn.style.marginTop = "60vh";

        // Redirection automatique après 10s
        setTimeout(() => {
            window.location.href = "fin.php";
        }, 10000);

        // Si l'utilisateur clique sur le bouton
        btn.addEventListener("click", () => {
            window.location.href = "fin.php";
        });
    }

});

console.log("JS chargé avec animations de dégâts");
